/** @file
 * $Author: kusanagi $
 * $Date: 2006/04/05 07:30:54 $
 * $Revision: 6.1 $
 * 
 * Header file for the algorithms used to read the techmodel data file.
 */

#include "TechmodelPamelaRun.h"
#include "TechmodelAlgorithm.h"

namespace pamela {
  namespace techmodel {
    /**
     * Main event reader algorithm. It handles all other specific
     * reader algorithms.
     */
    class EventReader: public TechmodelAlgorithm {
    private:
      /**
       * A map with an algorithm to read the techmodel file with the packet
       * type as key.
       */
      typedef std::map<const PacketType *, TechmodelAlgorithm *> AlgorithmMap;
      /**
       * The map that links every packet type to an algorithm that reads it.
       */
      AlgorithmMap TechmodelAlgorithmMap; //!
      /**
       * The event header.
       */
      EventHeader* Header; //!
      /**
       * The Run that is processed.
       */
      TechmodelPamelaRun *Run; //!
      void UnpackPscuHeader(void) throw (WrongCRCHeaderException, LengthException, BackwardCounterException);
      void UnpackPscuHeader(unsigned char*) throw (WrongCRCHeaderException, LengthException, BackwardCounterException);
      void UnpackPscuTrailer(void) throw (std::exception); 

      /**
        maxPackets define the maximum number of packets 
        the user wants to get from the raw file.
        By default is initialized to -1 (no limit)
      */
      static unsigned int maxPackets;

      /**
        prevPckCounter and prevPckOBT are used to check the
        integrity of the raw file stream 
      */
      static unsigned int prevPckCounter;
      static unsigned int prevPckOBT;
      std::stringstream oss;
      ofstream corruptedPacketFile;
      public:
      //EventReader(void);
      EventReader(int);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual std::string GetVersionInfo(void) const;
      virtual bool FindStart(unsigned char*, long) throw (std::exception);
      int archiveCorruptedPacket(long int, long int);
      ClassDef(EventReader, 1)
    };
  }
}
